<?php
/*======================================================================*\
|| #################################################################### ||
|| # Egg Avatar for vBulletin 3.8.x   								  # ||
|| # ---------------------------------------------------------------- # ||
|| # Originally created by [tk] Software (Hamster Powered)            # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'eggavatar');
define('CSRF_PROTECTION', true);
define('CLEAN_ALL', 3);
define('CLEAN_ANY', 2);
define('GOOD', 1);
define('BAD', 0);

// pre-cache templates used by all actions
$globaltemplates = array(
	'eggav_ajax',
	'eggav_bit',
	'eggav_eggbit',
	'eggav_cleanbit',
);

$actiontemplates = array(
	'egging' => array(
    	'eggav_ajax',
    	'eggav_bit',
    	'eggav_eggbit',
    	'eggav_cleanbit',
	)
);

// ######################### REQUIRE BCK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_eggavatar_image.php');

// ###################### Load the image handler ########################
$imagehandler = tk_Image::get_instance($vbulletin);

// #################### vB Optimise Integration #########################
if ($vbulletin->options['eggavatar_optimise'])
{
    require_once(DIR . '/includes/class_activecache.php');
    $vboptimise = vb_activecache::get_instance($vbulletin->options['_vboptimise_method']);
}

if ($_GET['do'] == 'showeggs')
{
    $_POST['do'] = 'showeggs';
}
if ($_POST['do'] == 'addegg')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'uid'         => TYPE_INT,
		'pid'         => TYPE_INT,
		'eggavatar'   => TYPE_STR,
	));   
    $userid = $vbulletin->GPC['uid'];
}
elseif ($_POST['do'] == 'showeggs')
{
    $vbulletin->input->clean_array_gpc('r', array(
		'u'          => TYPE_INT,
		'pid'        => TYPE_INT,
		'old'        => TYPE_STR,
	));
    $userid = $vbulletin->GPC['u'];
}
else
{
	$vbulletin->input->clean_array_gpc('p', array(
		'postid'     => TYPE_INT,
		'userid'     => TYPE_INT,
		'ajax'       => TYPE_BOOL,
	));

    $postid = $vbulletin->GPC['postid'];
    $userid = $vbulletin->GPC['userid'];
}

if (empty($userid))
{
    eval(standard_error(fetch_error('eggavatar_invalid_error')));    
}

// get user info (cannot be cached since we need the last login time)
$userquery = $vbulletin->db->query_first("
    SELECT * FROM " . TABLE_PREFIX . "user WHERE userid = " . $userid
);
$username = $userquery['username'];
$lastvisit = $userquery['lastvisit']; 

// get the expire time
$exp = $vbulletin->options['eggavatar_fadetime'] * 3600;

// invalidate cache if eggs have faded
if ($vbulletin->options['eggavatar_optimise'])
{
    $egg_cache = $vboptimise->fetch('eggs_' . $userid);
    if ($eggcache)
    {
        $eggs = unserialize($egg_cache);
        if (!empty($eggs))
        {
            $oldestegg = $eggs[count($eggs) - 1]['dateline'];
            if ($oldestegg + $exp < TIME_NOW AND $oldestegg < $lastvisit)
            {
                $vboptimise->set('totaleggs_' . $userid, '');
                $vboptimise->set('mytotaleggs_' . $vbulletin->userinfo['userid'] . '_' . $userid, '');
                $vboptimise->set('eggs_' . $userid, '');
                devdebug('[tk] Egg Avatar: Egg Avatar cache invalidated for userid ' . $userid);
            }
        }
    }
}
     	
// how many eggs are on this avatar?
if ($vbulletin->options['eggavatar_optimise'])
{
    $te_cache = $vboptimise->fetch('totaleggs_' . $userid);

    if ($te_cache) 
    { 
        $totaleggs = unserialize($te_cache);
        devdebug('vB Optimise: Fetched total eggs for userid ' . $userid);
    }
    else
    {
        $totaleggs = $vbulletin->db->query_first("SELECT COUNT(eggid) as totaleggs FROM " . TABLE_PREFIX . "eggavatar WHERE cleaned = 0 AND UNIX_TIMESTAMP() <= (dateline + " . $exp . ") AND userid=" . $userid);
        $vboptimise->set('totaleggs_' . $userid, serialize($totaleggs));
        devdebug('vB Optimise: Set total eggs for userid ' . $userid);
    }
}
else
{
        $totaleggs = $vbulletin->db->query_first("SELECT COUNT(eggid) as totaleggs FROM " . TABLE_PREFIX . "eggavatar WHERE cleaned = 0 AND UNIX_TIMESTAMP() <= (dateline + " . $exp . ") AND userid=" . $userid);
}
    
// get the clean cost for all eggs on the avatar
$cleanall_cost = $totaleggs['totaleggs'] * $vbulletin->options['eggavatar_cleancost'];

// get the total number of eggs on the avatar by the throwing user
$mytotaleggs = $vbulletin->db->query_first("SELECT COUNT(eggid) as totaleggs FROM " . TABLE_PREFIX . "eggavatar as eggavatar WHERE eggavatar.cleaned = 0 AND UNIX_TIMESTAMP() <= (eggavatar.dateline + " . $exp . ") AND userid=" . $userid . " AND eggedbyid=" . $vbulletin->userinfo['userid']);

// ######################### Add Egg ############################
if ($_POST['do'] == 'addegg')
{
    // look up the egg to add
    $egg = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "eggimage WHERE image='" . $vbulletin->GPC['eggavatar'] . "'");
    
    // deal with all the throw permutations first
    if ($egg['effect'] != CLEAN_ALL AND $egg['effect'] != CLEAN_ANY)
    {
        // do they have permission to throw eggs?
        if (!($permissions['eggavatarpermissions'] & $vbulletin->bf_ugp_eggavatarpermissions['eggavatarcanuseeggs']))
        {
        	eval(standard_error(fetch_error('eggavatar_invalid_error')));
        }
        
        // you cannot egg your own avatar
        if ($userid == $vbulletin->userinfo['userid'])
       	{
           eval(standard_error(fetch_error('eggavatar_your_error')));
       	}

        // there are too many eggs on this avatar already
    	if ($totaleggs['totaleggs'] >= $vbulletin->options['eggavatar_totaleggings'])
    	{
            eval(standard_error(fetch_error('eggavatar_totallimit_error', $vbulletin->options['eggavatar_totaleggings'])));
    	}
    	
    	// there are too many eggs by you on this avatar already
    	if ($mytotaleggs['totaleggs'] >= $vbulletin->options['eggavatar_maxeggings'])
    	{
            eval(standard_error(fetch_error('eggavatar_maxlimit_error', $mytotaleggs['totaleggs'])));
    	}
    }

    // now deal with all the clean permutations
    if (($egg['effect'] == CLEAN_ALL OR $egg['effect'] == CLEAN_ANY))
    {
        // there are no eggs to clean
     	if ($totaleggs['totaleggs'] == 0)
     	{
            eval(standard_error(fetch_error('eggavatar_nothingtoclean_error')));
        }

        // do they have permission to clean own eggs?
        if (!($permissions['eggavatarpermissions'] & $vbulletin->bf_ugp_eggavatarpermissions['eggavatarcancleanown']) AND $userid == $vbulletin->userinfo['userid'])
        {
        	eval(standard_error(fetch_error('eggavatar_invalid_error')));
        }

        // do they have permission to clean others eggs?
        if (!($permissions['eggavatarpermissions'] & $vbulletin->bf_ugp_eggavatarpermissions['eggavatarcancleanothers']) AND $userid != $vbulletin->userinfo['userid'])
        {
        	eval(standard_error(fetch_error('eggavatar_invalid_error')));
        }
    }

	// see if they can afford it
    if ($vbulletin->options['eggavatar_creditsenable'] > 0)
    {
        $ctable = $vbulletin->options['eggavatar_credittable'];
        $cfield = $vbulletin->options['eggavatar_creditfield'];
        $cuserid = $vbulletin->options['eggavatar_credituseridfield'];
        
        $vbulletin->db->hide_errors();
        $ucredits = $vbulletin->db->query_first("
            SELECT " . $cfield  . ' as credits' . " FROM " . TABLE_PREFIX . $ctable . "
            WHERE " . $cuserid . " = " . $vbulletin->userinfo['userid']
        );

        $vbulletin->db->show_errors();
        if (count($ucredits) == 0)
        {
            eval(standard_error(fetch_error('eggavatar_couldnotfindcredits_error')));
        }
     	if ($egg['effect'] == CLEAN_ALL AND $ucredits['credits'] - $cleanall_cost < 0)
     	{
            eval(standard_error(fetch_error('eggavatar_nocreditstoclean_error', $vbulletin->options['eggavatar_creditname'])));
     	}
        if ($egg['effect'] == CLEAN_ANY AND $ucredits['credits'] - $vbulletin->options['eggavatar_cleancost'] < 0)
        {
            eval(standard_error(fetch_error('eggavatar_nocreditstocleanall_error', $vbulletin->options['eggavatar_creditname'])));
        }
        if ($egg['effect'] != CLEAN_ANY AND $egg['effect'] != CLEAN_ALL AND $ucredits['credits'] - $vbulletin->options['eggavatar_eggcost'] < 0)
        {
            eval(standard_error(fetch_error('eggavatar_nocreditstoegg_error', $vbulletin->options['eggavatar_creditname'])));
        }

        if ($egg['effect'] == CLEAN_ALL)
        {
            $ucredits['credits'] -= $cleanall_cost;
        }
        elseif ($egg['effect'] == CLEAN_ANY)
        {
            $ucredits['credits'] -= $vbulletin->options['eggavatar_cleancost'];
        }
        else
        {
            $ucredits['credits'] -= $vbulletin->options['eggavatar_eggcost'];
        }
        $vbulletin->db->query_write("
            UPDATE " . TABLE_PREFIX . $ctable . " 
            SET " . $cfield . " = " . $ucredits['credits'] . "
            WHERE " . $cuserid . " = " . $vbulletin->userinfo['userid']
        );
    }	

    if ($egg['effect'] == CLEAN_ANY)
    {
        // clean one item
        $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "eggavatar SET cleaned = 1 WHERE userid = " . $userid . " AND cleaned <> 1 ORDER BY dateline DESC LIMIT 1");
    }
    elseif ($egg['effect'] == CLEAN_ALL)
    {
        // clean all items
        $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "eggavatar SET cleaned = 1 WHERE userid = " . $userid);
    }
    else
    {
        // write a new entry to the eggavatar table
        $vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "eggavatar (userid, postid, eggedbyid, eggtype, dateline) VALUES(" . $userid . ", " . $vbulletin->GPC['pid'] . ", " . $vbulletin->userinfo['userid'] . ", '"  . $vbulletin->GPC['eggavatar'] . "', " . TIMENOW . ")");
    }

    // invalidate the cache
    if ($vbulletin->options['eggavatar_optimise'])
    {
        $vboptimise->set('totaleggs_' . $userid, '');
        $vboptimise->set('eggs_' . $userid, '');
        $vboptimise->set('mostegged', '');
        $vboptimise->set('mostthrown', '');
        $vboptimise->set('mostpopular', '');
   
        devdebug('[tk] Egg Avatar: Egg Avatar cache invalidated for userid ' . $userid);
    }
       
    if ($vbulletin->options['eggavatar_userep'] AND $egg['effect'] < 2)
    {
        require_once(DIR . '/includes/functions_reputation.php');
        $userinfo = fetch_userinfo($userid);
        $rep = $egg['effect'] == BAD ? 'neg' : 'pos';
        $score = fetch_reppower($vbulletin->userinfo, $permissions, $rep);

    	$userinfo['reputation'] += $score;
    
    	// Determine this user's reputationlevelid.
    	$reputationlevel = $db->query_first_slave("
    		SELECT reputationlevelid
    		FROM " . TABLE_PREFIX . "reputationlevel
    		WHERE $userinfo[reputation] >= minimumreputation
    		ORDER BY minimumreputation
    		DESC LIMIT 1
    	");
    
    	// init user data manager
    	$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
    	$userdata->set_existing($userinfo);
    	$userdata->set('reputation', $userinfo['reputation']);
    	$userdata->set('reputationlevelid', intval($reputationlevel['reputationlevelid']));
    
    	$userdata->save();
    }
 
    // return the userid
    require_once(DIR . '/includes/class_xml.php');
    $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
    $xml->add_tag('userid', $userid);
    $xml->print_xml();
}

// ######################### Show Eggs ############################
if ($_POST['do'] == 'showeggs')
{
    require_once('includes/functions_eggavatar.php');
    if (!strstr($vbulletin->GPC['old'], 'image.php'))
    {
        // the source is a file
        $url = $vbulletin->GPC['old'];
        $imgdst = $imagehandler->fetch_image($url);
        $tfilename = $url;
    }
    else
    {
        // the source is in the database
        if ($imageinfo = $db->query_first_slave("
			SELECT filedata, dateline, filename
			FROM " . TABLE_PREFIX . "customavatar
			WHERE userid = " . $userid . " AND visible = 1
			HAVING filedata <> ''
		"));
		$imgdst = $imagehandler->fetch_image_from_string($imageinfo['filedata']);
		$tfilename = $imageinfo['filename'];
    }

    $eggcount = 0;
    if ($permissions['eggavatarpermissions'] & $vbulletin->bf_ugp_eggavatarpermissions['eggavatarcanvieweggs'])
    {
        $eggcount = egg_image($imagehandler, $imgdst, $userid, $vbulletin->options['eggavatar_eggpath'], $tfilename, $imageinfo['filedata'], $lastvisit);
    }

    if ($eggcount > 0)
    {
        $imagehandler->output($imgdst, $tfilename);
    }
    elseif (strstr($vbulletin->GPC['old'], 'image.php'))
    {
        header("Location: " . $vbulletin->GPC['old'] . "&dateline=" . $imageinfo['dateline']);
        header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
    }
    elseif (strstr($vbulletin->GPC['old'], "http"))
    {
		$extension = trim(substr(strrchr(strtolower($vbulletin->GPC['old']), '.'), 1));
		if ($extension == 'jpg' OR $extension == 'jpeg')
		{
			header('Content-type: image/jpeg');
		}
		else if ($extension == 'png')
		{
			header('Content-type: image/png');
		}
		else
		{
			header('Content-type: image/gif');
		}

        // create a new cURL resource
        $ch = curl_init();
        
        // set URL and other appropriate options
        curl_setopt($ch, CURLOPT_URL, $vbulletin->GPC['old']);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        
        // grab URL and pass it to the browser
        curl_exec($ch);
        
        // close cURL resource, and free up system resources
        curl_close($ch);
    }
    else
    {
        if (substr($vbulletin->GPC['old'], 0, 1) == "/")
        {
            $vbulletin->GPC['old'] = substr($vbulletin->GPC['old'], 1, strlen($vbulletin->GPC['old']) - 1);
        }
        $handle = fopen($vbulletin->GPC['old'], "r");
        echo fread($handle, filesize($vbulletin->GPC['old']));
        fclose($handle);
    }
}
// ######################### Ajax Populate Form ############################
else
{    
    $show['ajax'] = true;
    $show['egg'] = true;
    if (!($vbulletin->userinfo['permissions']['eggavatarpermissions'] & $vbulletin->bf_ugp_eggavatarpermissions['eggavatarcanuseeggs']))
    {
        $show['egg'] = false;
    }
	if ($userid == $vbulletin->userinfo['userid'])
	{
	   if ($vbulletin->userinfo['permissions']['eggavatarpermissions'] & $vbulletin->bf_ugp_eggavatarpermissions['eggavatarcancleanown'])
	   {
	       $show['egg'] = false;
	       $show['clean'] = $totaleggs > 0;
	   }
	   else
	   {
           eval(standard_error(fetch_error('eggavatar_your_error')));
       }
	}
	if ($vbulletin->userinfo['permissions']['eggavatarpermissions'] & $vbulletin->bf_ugp_eggavatarpermissions['eggavatarcancleanothers'])
    {
        $show['clean'] = $totaleggs > 0;
    }

    if (!$show['egg'] AND !$show['clean'])
    {
        eval(standard_error(fetch_error('eggavatar_nothingtodo_error')));
    }

    $dircheck = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "eggimage WHERE active = 1 LIMIT 1");
    if (!file_exists(DIR . '/' . $vbulletin->options[eggavatar_eggpath] . $dircheck['image']))
    {
        eval(standard_error(fetch_error('eggavatar_invalid_path')));
    }

    // first add all the active eggs that can be thrown
    $throwable = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "eggimage WHERE active = 1");
    $count = 0;
    while ($throw = $vbulletin->db->fetch_array($throwable))
    {
        $imagesrc = $vbulletin->options[eggavatar_eggpath] . $throw[image];
        $checked = ($count == 0) ? 'checked' : '';
        $count++;
        if ($throw['effect'] < 2)
        {
            eval('$eggavatar_eggbits .= "' . fetch_template('eggav_eggbit') . '";');
        }
        else
        {
            eval('$eggavatar_cleanbits .= "' . fetch_template('eggav_cleanbit') . '";');
        }
    }
    
	eval('$eggavatar_bit = "' . fetch_template('eggav_bit') . '";');
	eval('$eggavatar_ajax = "' . fetch_template('eggav_ajax') . '";');

	require_once(DIR . '/includes/class_xml.php');
	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_tag('eggavatar_ajax', process_replacement_vars($eggavatar_ajax));
	$xml->print_xml();
}

?>